/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ShulkerBoxTooltipClient {
    private static ItemStack previousStack = null;
    public static Minecraft client;
    private static boolean wasPreviewAccessed;
    private static boolean previewKeyPressed;
    private static boolean fullPreviewKeyPressed;

    public static void init() {
        client = Minecraft.m_91087_();
        ClientNetworking.init();
    }

    public static boolean shouldDisplayPreview() {
        return ShulkerBoxTooltip.config.preview.alwaysOn || ShulkerBoxTooltipApi.isPreviewKeyPressed();
    }

    @Nullable
    public static Component getTooltipHint(PreviewContext context, PreviewProvider provider) {
        boolean shouldDisplay = ShulkerBoxTooltipClient.shouldDisplayPreview();
        if (!ShulkerBoxTooltip.config.preview.enable || !provider.shouldDisplay(context) || shouldDisplay && ShulkerBoxTooltipApi.isFullPreviewKeyPressed()) {
            return null;
        }
        boolean fullPreviewAvailable = provider.isFullPreviewAvailable(context);
        if (!fullPreviewAvailable && shouldDisplay) {
            return null;
        }
        MutableComponent keyHint = Component.m_237113_((String)"");
        Component previewKeyText = ShulkerBoxTooltip.config.controls.previewKey.get().m_84875_();
        if (shouldDisplay) {
            keyHint.m_7220_(ShulkerBoxTooltip.config.controls.fullPreviewKey.get().m_84875_());
            if (!ShulkerBoxTooltip.config.preview.alwaysOn) {
                keyHint.m_130946_("+").m_7220_(previewKeyText);
            }
        } else {
            keyHint.m_7220_(previewKeyText);
        }
        keyHint.m_130946_(": ");
        keyHint.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        String contentHint = ShulkerBoxTooltipApi.getCurrentPreviewType(fullPreviewAvailable) == PreviewType.NO_PREVIEW ? (ShulkerBoxTooltip.config.preview.swapModes ? provider.getFullTooltipHintLangKey(context) : provider.getTooltipHintLangKey(context)) : (ShulkerBoxTooltip.config.preview.swapModes ? provider.getTooltipHintLangKey(context) : provider.getFullTooltipHintLangKey(context));
        return keyHint.m_7220_((Component)Component.m_237115_((String)contentHint).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)));
    }

    public static void modifyStackTooltip(ItemStack stack, List<Component> tooltip) {
        if (client == null) {
            return;
        }
        PreviewContext context = PreviewContext.of(stack, (Player)ShulkerBoxTooltipClient.client.f_91074_);
        PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(stack);
        if (provider == null) {
            return;
        }
        if (previousStack == null || !ItemStack.m_41728_((ItemStack)stack, (ItemStack)previousStack)) {
            wasPreviewAccessed = false;
        }
        previousStack = stack;
        if (!wasPreviewAccessed) {
            provider.onInventoryAccessStart(context);
        }
        wasPreviewAccessed = true;
        if (provider.showTooltipHints(context)) {
            Component hint;
            if (ShulkerBoxTooltip.config.tooltip.type == Configuration.ShulkerBoxTooltipType.MOD) {
                tooltip.addAll(provider.addTooltip(context));
            }
            if (ShulkerBoxTooltip.config.tooltip.showKeyHints && (hint = ShulkerBoxTooltipClient.getTooltipHint(context, provider)) != null) {
                tooltip.add(hint);
            }
        }
    }

    public static boolean isPreviewKeyPressed() {
        return previewKeyPressed;
    }

    public static boolean isFullPreviewKeyPressed() {
        return fullPreviewKeyPressed;
    }

    private static boolean isKeyPressed(@Nullable Key key) {
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.get().equals((Object)InputConstants.f_84822_)) {
            return false;
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.get().m_84873_());
    }

    public static void updatePreviewKeys() {
        Configuration config = ShulkerBoxTooltip.config;
        if (config == null) {
            previewKeyPressed = false;
            fullPreviewKeyPressed = false;
        } else {
            previewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.previewKey);
            fullPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.fullPreviewKey);
        }
    }

    static {
        wasPreviewAccessed = false;
        previewKeyPressed = false;
        fullPreviewKeyPressed = false;
    }
}

